<?php

namespace Drupal\advanced_header_field_navigation\Plugin\Block;

use Drupal\Core\Block\Attribute\Block;
use Drupal\Core\Block\BlockBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

#[Block(
  id: "ahf_navigation_jump_menu",
  admin_label: new TranslatableMarkup("Advanced Header Field Jump Menu"),
  category: new TranslatableMarkup("Navigation")
)]

/**
 * Provides a jump menu block.
 */
class JumpMenu extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build() {
    return [
      '#theme' => 'ahf_navigation_jump_menu',
      '#attached' => [
        'library' => [
          'advanced_header_field_navigation/jump-menu',
        ],
      ],
    ];
  }

}
