# Advanced Mega Menu

The **Advanced Mega Menu** module provides a powerful, grid-based layout
builder for Drupal navigation, enabling site builders to create complex,
multi-row, and multi-column layouts through an intuitive visual interface.

Unlike traditional static menus, every element within the mega menu is
fully dynamic. By embedding Views, Block entities, and System blocks,
the module ensures your navigation renders real-time data that updates
automatically as your content changes. These components leverage Drupal’s
core visibility system and Views contextual filters, allowing you to serve
personalized content based on user roles, page types, or specific URL
contexts. Designed for high performance and full responsiveness, it is
the definitive choice for enterprise sites requiring a smart, data-driven
navigation system.

## Table of Contents

*   [Features](#features)
*   [Requirements](#requirements)
*   [Installation](#installation)
*   [Configuration Workflow](#configuration)
*   [Design & Theming Note](#theming-note)
*   [Troubleshooting](#troubleshooting)

## Features

*   **Core Functionality:** Transforms standard Drupal menu trees into
grid-based navigation using a canvas-style interface.
*   **Fully Dynamic Content:** Embed Views, Block Content entities, and
System blocks that update automatically.
*   **Contextual Intelligence:** Personalize content based on user roles,
page types, or URL context using core visibility and Views filters.
*   **Hybrid Rendering:** Mix traditional menu links with custom blocks;
position child links above, below, or hide them.
*   **Mobile-Ready:** Automatic conversion of desktop grids into touch-friendly
vertical accordions.
*   **Decoupled Support:** Built-in REST endpoints for headless frontends
(React, Vue, etc.).

## Requirements

*   Drupal 10, or 11
*   Drupal Core Modules: REST, Block, Views, Serialization

## Installation

Install the Advanced Mega Menu module via Composer:

```
composer require drupal/advanced_mega_menu
```

Enable the module using Drush:

```
drush en advanced_mega_menu
```

Alternatively, install it like a standard contributed module. Navigate
to **People » Permissions** to grant the _Administer Advanced Mega
Menu_ permission to trusted roles.

## Configuration Workflow

### Step 1: Enable Menu Support

Designate which menus should support Mega Menu functionality:

*   **Option A:** Navigate to **Structure » Menus**. In the "Operations"
dropdown for your chosen menu, select **Enable Mega Menu**.
*   **Option B:** Go to **Structure » Advanced Mega Menu » Configuration**.
Select multiple menus (e.g., Main, Footer) and click **Save**.

### Step 2: Access the Visual Builder

Go to **Structure » Menus** and edit an enabled menu. Hover over a menu
link to reveal the builder icons:

*   **Gear Icon:** Opens the Layout Builder in an AJAX modal.
*   **External Link Icon:** Opens the full-screen Layout Builder.

### Step 3: Architect the Layout

The builder uses a hierarchical "Canvas" approach:

*   **Add Row:** Create a horizontal container. Use Column Width Mode
for predefined layouts or choose Custom for your own grid classes.
*   **Add Column:** Divide your row into vertical segments.
*   **Add Block:** Populate columns with dynamic content (Views, Blocks,
etc.).

## Design & Theming Note

**Important:** This module provides the structural framework and grid
engine, but it **does not provide a finished design**. All content is
rendered according to your active theme's styling. Users will need to
apply custom CSS to match their specific requirements.

## Template Override Instructions

*   Enable Debugging: Enable Twig Debug Mode to view template suggestions in your browser's "Inspect Element" tool.

*   Verify Source: Check if the system is currently using menu--advanced-mega-menu.html.twig from the module.

*   Copy & Rename: If the active theme isn't using it, copy that file into your theme's templates folder and rename it to the highest priority suggestion like: menu--primary-menu.html.twig

## Troubleshooting

*   **Menu not showing**: Ensure “Enable Mega Menu” is checked on both global and item-level settings
*   **Top-Level Restriction**: Please note that mega menu functionality is designed to work only for **top-level menu items**.
*   **CSS classes not applied**: Confirm your theme doesn’t override module templates
*   **Missing blocks**: Check permissions and visibility for embedded content
*   ****Template Not Overriding:****  
    *   ****Enable Debugging:**** Enable ****Twig Debug Mode**** to view template suggestions in your browser's "Inspect Element" tool.
    *   ****Verify Source:**** Check if the system is currently using `menu--advanced-mega-menu.html.twig` from the module.
    *   ****Copy & Rename:**** If the active theme isn't using it, copy that file into your theme's `templates` folder and rename it to the highest priority suggestion like: `**menu--primary-menu.html.twig**`**

## Maintainers

This module is maintained by [sujan-shrestha](https://www.drupal.org/u/sujan-shrestha).
