(function (Drupal, once) {
  Drupal.behaviors.advancedMegaMenu = {
    attach(context) {
      /* ------------------------------------
       * Mobile submenu toggle
       * ---------------------------------- */
      once('submenu-toggle', '.submenu-icon', context).forEach((icon) => {
        icon.addEventListener('click', (e) => {
          if (window.innerWidth <= 992) {
            e.preventDefault();
            e.stopPropagation();
            icon
              .closest('.advanced-mega-menu-item')
              ?.classList.toggle('active');
          }
        });
      });

      /* ------------------------------------
       * Submenu collision detection
       * ---------------------------------- */
      once(
        'submenu-collision',
        '.advanced-mega-menu-item.has-submenu',
        context,
      ).forEach((item) => {
        item.addEventListener('mouseenter', () => {
          if (window.innerWidth > 992) {
            const submenu = item.querySelector('ul.advanced-mega-menu');
            if (!submenu) {
              return;
            }

            item.classList.remove('open-left');
            const rect = submenu.getBoundingClientRect();

            if (rect.right > window.innerWidth) {
              item.classList.add('open-left');
            }
          }
        });
      });

      /* ------------------------------------
       * Mega menu panel collision handling
       * ---------------------------------- */
      once('mega-menu-panel', '.advanced-mega-menu-item.mega', context).forEach(
        (item) => {
          const panel = item.querySelector('.advanced-mega-menu-panel');
          if (!panel) return;

          const edgeBuffer = 20;

          function adjustMegaPanel() {
            if (window.innerWidth <= 992) {
              panel.style.removeProperty('--menu-shift');
              return;
            }

            // Reset before measuring
            panel.style.removeProperty('--menu-shift');

            const rect = panel.getBoundingClientRect();
            const viewportWidth = window.innerWidth;

            let shiftX = 0;

            if (rect.right > viewportWidth - edgeBuffer) {
              shiftX = rect.right - viewportWidth + edgeBuffer;
            } else if (rect.left < edgeBuffer) {
              shiftX = rect.left - edgeBuffer;
            }

            if (shiftX !== 0) {
              panel.style.setProperty('--menu-shift', `${shiftX}px`);
            }
          }

          item.addEventListener('mouseenter', adjustMegaPanel);
          item.addEventListener('mouseleave', () => {
            panel.style.removeProperty('--menu-shift');
          });

          /* -------- Debounced resize -------- */
          let resizeTimeout;
          window.addEventListener('resize', () => {
            clearTimeout(resizeTimeout);
            resizeTimeout = setTimeout(adjustMegaPanel, 100);
          });
        },
      );
    },
  };
})(Drupal, once);
