<?php

namespace Drupal\advanced_mega_menu\Ajax;

use Drupal\Core\Ajax\CommandInterface;

/**
 * Custom AJAX command to scroll to a specific element.
 */
class ScrollToCommand implements CommandInterface {

  /**
   * The CSS selector of the element to scroll to.
   *
   * @var string
   */
  protected $selector;

  /**
   * Constructs a new ScrollToCommand.
   *
   * @param string $selector
   *   A valid CSS selector identifying the target element.
   */
  public function __construct($selector) {
    $this->selector = $selector;
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    return [
      'command' => 'megaMenuScrollTo',
      'selector' => $this->selector,
    ];
  }

}
