<?php

namespace Drupal\advanced_mega_menu;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * LeaveConfirmPoint Point Entity Interface.
 *
 * @package Drupal\advanced_mega_menu
 *
 * Provides an interface defining a LeaveConfirmPointPoint entity.
 */
interface MegaMenuContentInterface extends ConfigEntityInterface {

  /**
   * Getter for form machine ID property.
   *
   * @return string
   *   Machine name form id.
   */
  public function getFormId();

  /**
   * Setter for label property.
   *
   * @param string $form_id
   *   Form machine ID string.
   */
  public function setFormId($form_id);

  /**
   * Getter for form menu ID property.
   *
   * @return string
   *   Machine name menu_id.
   */
  public function getMenuId();

  /**
   * Setter for menu id property.
   *
   * @param string $menu_id
   *   Form machine ID string.
   */
  public function setMenuId($menu_id);

  /**
   * Getter for label property.
   *
   * @return string
   *   Label string.
   */
  public function getLabel();

  /**
   * Setter for label property.
   *
   * @param string $label
   *   Label string.
   */
  public function setLabel($label);

  /**
   * Getter for label property.
   *
   * @return string
   *   Label string.
   */
  public function getRows();

  /**
   * Sets the rows configuration.
   *
   * Stores the row layout data used to build the mega menu structure.
   *
   * @param array $rows
   *   An array of row definitions, including column and field configuration.
   *
   * @return $this
   *   The called object for method chaining.
   */
  public function setRows(array $rows);

  /**
   * Getter for status property.
   *
   * @return string
   *   Label string.
   */
  public function getStatus();

  /**
   * Sets the status of the entity.
   *
   * Indicates whether the entity is enabled or disabled.
   *
   * @param bool $status
   *   TRUE if the entity is enabled, FALSE if it is disabled.
   *
   * @return $this
   *   The called object for method chaining.
   */
  public function setStatus($status);

  /**
   * Getter for display settings property.
   *
   * @return string
   *   Label string.
   */
  public function getDisplaySettings();

  /**
   * Sets the display settings for the entity.
   *
   * Stores configuration controlling how the entity is rendered or displayed,
   * such as layout options, visibility rules, or presentation preferences.
   *
   * @param array $display_settings
   *   An associative array of display configuration values.
   *
   * @return $this
   *   The called object for method chaining.
   */
  public function setDisplaySettings($display_settings);

}
