<?php

namespace Drupal\Tests\advanced_mega_menu\FunctionalJavascript;

use Drupal\FunctionalJavascriptTests\WebDriverTestBase;

/**
 * Tests the JavaScript functionality of the Advanced Mega Menu.
 *
 * @group advanced_mega_menu
 */
class AdvancedMegaMenuFormTest extends WebDriverTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'block',
    'advanced_mega_menu',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Tests the custom megaMenuScrollTo AJAX command.
   */
  public function testScrollToCommand() {
    $this->drupalLogin($this->drupalCreateUser(['administer blocks']));

    // This test would trigger an action that returns your custom AJAX command.
    // We verify if the highlight class is added as defined in your JS.
    $this->drupalGet('admin/config/structure/advanced-mega-menu/settings');

    $page = $this->getSession()->getPage();
    $ajax_button = $page->find('css', '.trigger-scroll-button');

    if ($ajax_button) {
      $ajax_button->click();
      $this->assertSession()->assertWaitOnAjaxRequest();

      // Verify the JS highlight class was applied.
      // Your JS adds 'ajax-new-item-highlight' for 2000ms.
      $highlighted = $page->find('css', '.ajax-new-item-highlight');
      $this->assertNotEmpty($highlighted, 'The scroll-to highlight class was applied to the target.');
    }
  }

}
