<?php

namespace Drupal\Tests\advanced_mega_menu\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\Core\Form\FormState;
use Drupal\system\Entity\Menu;
use Drupal\Core\Menu\MenuLinkTreeElement;
use Drupal\Core\Menu\MenuLinkInterface;

/**
 * Tests hook implementations in advanced_mega_menu.module.
 *
 * @group advanced_mega_menu
 */
class AdvancedMegaMenuModuleTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'user',
    'menu_link_content',
    'link',
    'advanced_mega_menu',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installEntitySchema('menu_link_content');
    $this->installConfig(['advanced_mega_menu']);

    // Create a test menu.
    Menu::create(['id' => 'main', 'label' => 'Main Menu'])->save();
  }

  /**
   * Tests advanced_mega_menu_form_menu_edit_form_alter().
   */
  public function testMenuEditFormAlter() {
    // 1. Enable 'main' menu in config.
    $this->config('advanced_mega_menu.settings')
      ->set('enabled_menus', ['main'])
      ->save();

    // 2. Create a Real MenuLinkTreeElement to satisfy "instanceof".
    // We mock the Plugin so we don't need a full database entry for the link.
    $link_plugin = $this->createMock(MenuLinkInterface::class);
    $link_plugin->method('getPluginId')->willReturn('menu_link_content:1234');
    $link_plugin->method('getTitle')->willReturn('Home');

    $tree_element = new MenuLinkTreeElement($link_plugin, FALSE, 1, FALSE, []);

    // 3. Mock the form array structure.
    $form = [
      'links' => [
        'links' => [
          'menu_plugin_id:test_link' => [
            '#item' => $tree_element,
            'title' => [],
          ],
        ],
      ],
    ];

    $form_state = new FormState();

    // 4. Mock the Form Object to return our Menu entity.
    $menu_entity = Menu::load('main');
    $form_object = $this->getMockBuilder('\Drupal\menu_ui\MenuForm')
      ->disableOriginalConstructor()
      ->onlyMethods(['getEntity'])
      ->getMock();
    $form_object->method('getEntity')->willReturn($menu_entity);

    $form_state->setFormObject($form_object);

    // 5. Run the alter.
    advanced_mega_menu_form_menu_edit_form_alter($form, $form_state, 'menu_edit_form');

    // ASSERT: Size 0 became size 2.
    $links_container = $form['links']['links']['menu_plugin_id:test_link']['title'];
    $this->assertCount(2, $links_container, 'The "Mega Menu" and "Config" links were successfully injected.');

    // Verify the links have the correct attributes.
    $this->assertContains('use-ajax', $links_container[0]['#attributes']['class']);
    $this->assertEquals('_blank', $links_container[1]['#attributes']['target']);
  }

}
