<?php

namespace Drupal\Tests\advanced_mega_menu\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\advanced_mega_menu\Form\MegaMenuContentSettingsForm;
use Drupal\Core\Form\FormState;

/**
 * Tests the Mega Menu Content Settings Form.
 *
 * @group advanced_mega_menu
 */
class MegaMenuContentSettingsFormTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   *
   * Core + custom modules required for this test.
   */
  protected static $modules = [
    'system',
    'user',
    'link',
    'menu_link_content',
    'advanced_mega_menu',
  ];

  /**
   * The form object.
   *
   * @var \Drupal\advanced_mega_menu\Form\MegaMenuContentSettingsForm
   */
  protected $form;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Install configuration and schema.
    $this->installConfig(['advanced_mega_menu']);

    // Install entity schemas.
    $this->installEntitySchema('menu');
    $this->installEntitySchema('menu_link_content');

    // Instantiate the form manually via container.
    $this->form = new MegaMenuContentSettingsForm($this->container->get('entity_type.manager'));
  }

  /**
   * Tests the buildForm() method.
   */
  public function testBuildForm(): void {
    $form_state = new FormState();
    $form = $this->form->buildForm([], $form_state);

    $this->assertArrayHasKey('enabled_menus', $form, 'Enabled menus fieldset exists.');
    $this->assertArrayHasKey('submenu_icons', $form, 'Submenu icons fieldset exists.');
    $this->assertArrayHasKey('disable_assets', $form, 'Disable assets checkbox exists.');

    $this->assertArrayHasKey('submenu_icon_enabled', $form['submenu_icons']);
    $this->assertArrayHasKey('submenu_icon_source', $form['submenu_icons']);
    $this->assertArrayHasKey('aria_labels', $form['submenu_icons']);
  }

  /**
   * Tests the submitForm() method.
   */
  public function testSubmitForm(): void {
    $form_state = new FormState();

    // Fake menus for testing.
    $menus = ['main', 'footer'];
    $form_state->set('menu_keys', $menus);
    $form_state->setValue('main', TRUE);
    $form_state->setValue('footer', FALSE);

    $form_state->setValue('disable_assets', TRUE);
    $form_state->setValue('submenu_icon_enabled', TRUE);
    $form_state->setValue('submenu_icon_separate_states', FALSE);
    $form_state->setValue('submenu_icon_source', 'unicode');
    $form_state->setValue('submenu_icon_unicode_expand', '▶');
    $form_state->setValue('submenu_icon_unicode_collapse', '▼');
    $form_state->setValue('submenu_icon_aria', 'Expand submenu');

    $form = [];

    $this->form->submitForm($form, $form_state);

    $config = $this->container->get('config.factory')->getEditable('advanced_mega_menu.settings');

    $this->assertEquals(['main'], $config->get('enabled_menus'), 'Enabled menus saved correctly.');
    $this->assertTrue($config->get('disable_assets'), 'Disable assets saved correctly.');
    $this->assertEquals(1, $config->get('submenu_icon.enabled'), 'Submenu icon enabled saved correctly.');
    $this->assertEquals('▶', $config->get('submenu_icon.unicode_expand'));
    $this->assertEquals('▼', $config->get('submenu_icon.unicode_collapse'));
    $this->assertEquals('Expand submenu', $config->get('submenu_icon.aria'));
  }

}
