<?php

namespace Drupal\Tests\advanced_mega_menu\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\advanced_mega_menu\Entity\MegaMenuContent;
use Drupal\advanced_mega_menu\Service\MegaMenuBlockRenderer;

/**
 * Tests the MegaMenuContent config entity.
 *
 * @group advanced_mega_menu
 */
class MegaMenuContentTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['system', 'user', 'advanced_mega_menu'];

  /**
   * Tests the transformation logic in getRowsData.
   */
  public function testGetRowsDataTransformation(): void {
    // 1. Create a mock of the Block Renderer.
    $mock_renderer = $this->createMock(MegaMenuBlockRenderer::class);
    $mock_renderer->method('renderThemeBlock')->willReturn(['#markup' => 'Theme Block Rendered']);
    $mock_renderer->method('renderViewBlock')->willReturn(['#markup' => 'View Block Rendered']);

    // 2. Inject the mock into the container.
    $this->container->set('advanced_mega_menu.block_renderer', $mock_renderer);

    // 3. Setup the entity with complex row data.
    $entity = MegaMenuContent::create([
      'form_id' => 'test_mega_menu',
      'label' => 'Test Label',
      'rows' => [
        [
          'column_layout_mode' => 'fixed',
          'columns' => [
            [
              'blocks' => [
                [
                  'category' => 'theme_id',
                  'theme_id' => 'system_powered_by_block',
                  'show_label' => TRUE,
                ],
                [
                  'category' => 'view_id',
                  'view_id' => 'who_is_online:block_1',
                ],
              ],
            ],
          ],
        ],
      ],
    ]);

    // 4. Execute the logic.
    $data = $entity->getRowsData();

    // 5. Assertions.
    $this->assertCount(1, $data, 'One row should be processed.');
    $this->assertEquals('fixed', $data[0]['column_layout_mode']);

    // Check Theme Block.
    $theme_block = $data[0]['columns'][0][0]['block'];
    $this->assertEquals('Theme Block Rendered', $theme_block['#markup']);

    // Check View Block (Verify the explode logic worked).
    $view_block = $data[0]['columns'][0][1]['block'];
    $this->assertEquals('View Block Rendered', $view_block['#markup']);
  }

  /**
   * Tests getters and setters.
   */
  public function testGettersSetters(): void {
    $entity = MegaMenuContent::create(['form_id' => 'my_menu']);
    $entity->setLabel('New Label');
    $this->assertEquals('New Label', $entity->getLabel());
    $this->assertEquals('my_menu', $entity->id());
  }

}
