<?php

namespace Drupal\Tests\advanced_mega_menu\Unit\Ajax;

use Drupal\advanced_mega_menu\Ajax\ScrollToCommand;
use Drupal\Tests\UnitTestCase;

/**
 * @coversDefaultClass \Drupal\advanced_mega_menu\Ajax\ScrollToCommand
 * @group advanced_mega_menu
 */
class ScrollToCommandTest extends UnitTestCase {

  /**
   * Tests the render() method.
   *
   * Why: This ensures that the PHP object correctly serializes into the
   * array format that Drupal's AjaxResponse expects to convert to JSON.
   */
  public function testRender() {
    $selector = '.mega-menu-item-42';
    $command = new ScrollToCommand($selector);

    $expected = [
      'command' => 'megaMenuScrollTo',
      'selector' => $selector,
    ];

    // Assert that the render method returns the correct structure.
    $this->assertEquals($expected, $command->render());
  }

  /**
   * Tests with a different selector to ensure the data is dynamic.
   */
  public function testRenderWithDifferentSelector() {
    $selector = '#edit-mega-menu-row-0';
    $command = new ScrollToCommand($selector);

    $render = $command->render();

    $this->assertEquals($selector, $render['selector']);
    $this->assertEquals('megaMenuScrollTo', $render['command']);
  }

}
