<?php

declare(strict_types=1);

namespace Drupal\advanced_message_subscription;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\advanced_message_subscription\Attribute\AdvancedMessageSubscription;

/**
 * AdvancedMessageSubscription plugin manager.
 */
class AdvancedMessageSubscriptionPluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/AdvancedMessageSubscription', $namespaces, $module_handler, AdvancedMessageSubscriptionPluginInterface::class, AdvancedMessageSubscription::class);
    $this->alterInfo('advanced_message_subscription_info');
    $this->setCacheBackend($cache_backend, 'advanced_message_subscription_plugins');
  }

}
