<?php

declare(strict_types=1);

namespace Drupal\advanced_message_subscription;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * List builder for advanced message subscription entities.
 *
 * @see \Drupal\advanced_message_subscription\Entity\AdvancedMessageSubscriptionType
 */
class AdvancedMessageSubscriptionTypeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['label'] = $this->t('Type');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    $row['label'] = $entity->label();
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function render(): array {
    $build = parent::render();

    $build['table']['#empty'] = $this->t(
      'No advanced message subscription types available. <a href=":link">Add advanced message subscription type</a>.',
      [':link' => Url::fromRoute('entity.adv_message_subscription_type.add_form')->toString()],
    );

    return $build;
  }

}
