<?php

namespace Drupal\advanced_message_subscription\Entity;

use Drupal\Core\Config\Entity\ConfigEntityStorage;

/**
 * Storage handler for advanced message subscription types.
 */
class AdvancedMessageSubscriptionTypeStorage extends ConfigEntityStorage {

  /**
   * Load subscription types by plugin ID.
   *
   * @param string $plugin_id
   *   The plugin ID to filter for.
   *
   * @return \Drupal\advanced_message_subscription\Entity\AdvancedMessageSubscriptionType[]
   *   Subscriptions using the given plugin ID.
   */
  public function loadByPluginId(string $plugin_id): array {
    return array_filter($this->loadMultiple(), function (AdvancedMessageSubscriptionType $subscription_type) use ($plugin_id) {
      return $subscription_type->getPluginId() == $plugin_id;
    });
  }

}
