<?php

declare(strict_types=1);

namespace Drupal\advanced_message_subscription;

use Drupal\advanced_message_subscription\Entity\AdvancedMessageSubscriptionType;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining an advanced message subscription entity type.
 */
interface AdvancedMessageSubscriptionInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * Get the subscription type.
   */
  public function getType(): AdvancedMessageSubscriptionType;

}
