<?php

/**
 * @file
 * Hooks for the Advanced Message Subscription module.
 */

/**
 * Act on an event as it's processed.
 *
 * @param \Drupal\advanced_message_subscription\AdvancedMessageSubscriptionEvent $event
 *   The event.
 */
function hook_advanced_message_subscription_event_process(\Drupal\advanced_message_subscription\AdvancedMessageSubscriptionEvent $event) {
  // Skip on Thursdays.
  if (date('w') == 4) {
    $event->cancel();
  }
}

/**
 * Allows other modules to affect the query for looking up subscriptions.
 *
 * @param \Drupal\Core\Entity\Query\QueryInterface $query
 *   The entity query used to look up subscriptions.
 * @param \Drupal\advanced_message_subscription\AdvancedMessageSubscriptionEvent $event
 *   The event.
 * @param \Drupal\advanced_message_subscription\Entity\AdvancedMessageSubscriptionType $subscription_type
 *   The subscription type.
 */
function hook_advanced_message_subscription_query(\Drupal\Core\Entity\Query\QueryInterface $query, \Drupal\advanced_message_subscription\AdvancedMessageSubscriptionEvent $event, \Drupal\advanced_message_subscription\Entity\AdvancedMessageSubscriptionType $subscription_type) {
  // Omit users who have silenced this message.
  if ($subscription_type->id() == 'wakeup') {
    // Assumes the user entity has a "field_silenced" boolean field.
    $query->condition('uid.entity.field_silenced', 1, '!=');
  }
}

/**
 * Allows other modules to alter a message as it's being created.
 *
 * Note, the message has not yet been saved but will be saved later in the
 * creation process.
 *
 * @param \Drupal\message\MessageInterface $message
 *   The message being created, not yet saved.
 * @param \Drupal\advanced_message_subscription\AdvancedMessageSubscriptionInterface $subscription
 *   The subscription that the message is being created for.
 * @param array $data
 *   Other data pertinent to the event.
 */
function hook_advanced_message_subscription_message_create(\Drupal\message\MessageInterface $message, \Drupal\advanced_message_subscription\AdvancedMessageSubscriptionInterface $subscription, array $data) {
  if ($subscription->bundle() == 'expiring_message') {
    // Assumes the message entity/bundle has a "field_silenced" boolean field.
    $message->field_expires = strtotime('now +2 weeks');
  }
}

/**
 * Allows other modules to cancel a notification for a message.
 *
 * @param \Drupal\message\MessageInterface $message
 *   The message being created, not yet saved.
 * @param \Drupal\advanced_message_subscription\AdvancedMessageSubscriptionInterface $subscription
 *   The subscription that the message is being created for.
 * @param array $data
 *   Other data pertinent to the event.
 *
 * @return ?bool
 *   Indicates if the notification should be canceled. Returning any non falsey
 *   value will cancel the notification.
 */
function hook_message_notify_subscription_notify_cancel(\Drupal\message\MessageInterface $message, \Drupal\advanced_message_subscription\AdvancedMessageSubscriptionInterface $subscription, array $data): ?bool {
  return $subscription->field_send_mail->value != TRUE;
}
