<?php

namespace Drupal\advanced_message_subscription;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Access controller for the Advanced Message Subscription entity.
 *
 * @see \Drupal\advanced_message_subscription\Entity\AdvancedMessageSubscription.
 */
class AdvancedMessageSubscriptionAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  public function createAccess($entity_bundle = NULL, ?AccountInterface $account = NULL, array $context = [], $return_as_object = FALSE) {
    $account = $this->prepareUser($account);
    $parent_result = parent::createAccess($entity_bundle, $account, $context, $return_as_object);

    $result = AccessResult::allowedIfHasPermission($account, 'manage own advanced_message_subscriptions');

    if ($return_as_object) {
      return $result->orIf($parent_result);
    }
    return $parent_result && $result->isAllowed();
  }

  /**
   * {@inheritdoc}
   */
  public function access(EntityInterface $entity, $operation, ?AccountInterface $account = NULL, $return_as_object = FALSE) {
    assert($entity instanceof AdvancedMessageSubscriptionInterface);

    $account = $this->prepareUser($account);
    $parent_result = parent::access($entity, $operation, $account, $return_as_object);

    switch ($operation) {
      case 'view':
      case 'update':
      case 'delete':
        $result = AccessResult::allowedIfHasPermission($account, 'manage own advanced_message_subscriptions')
          ->andIf(AccessResult::allowedIf($entity->getOwnerId() == $account->id()));
        break;

      default:
        $result = AccessResult::neutral();
    }

    $result->addCacheableDependency($account)->addCacheableDependency($entity);

    if ($return_as_object) {
      return $result->orIf($parent_result);
    }
    return $parent_result && $result->isAllowed();
  }

}
