<?php

namespace Drupal\advanced_message_subscription;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Access controller for the Advanced Message Subscription Type entity.
 *
 * @see \Drupal\advanced_message_subscription\Entity\AdvancedMessageSubscriptionType.
 */
class AdvancedMessageSubscriptionTypeAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'manage own advanced_message_subscriptions');

      default:
        return parent::checkAccess($entity, $operation, $account);
    }
  }

}
