<?php

declare(strict_types=1);

namespace Drupal\advanced_message_subscription;

use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Data provider for subscriptions.
 */
class DataProvider {

  /**
   * Constructs a DataProvider.
   *
   * @param \Drupal\Core\Routing\RouteMatchInterface $routeMatch
   *   The route match service.
   */
  public function __construct(
    protected RouteMatchInterface $routeMatch,
  ) {
    // No op.
  }

  /**
   * Get the data parameter.
   *
   * @return mixed|null
   *   The parameter value.
   */
  public function getDataParam() {
    return $this->getRouteParameter('data');
  }

  /**
   * Get a route parameter from the current route.
   *
   * @param string $parameter
   *   The route parameter name.
   *
   * @return mixed|null
   *   The parameter value.
   */
  public function getRouteParameter(string $parameter): mixed {
    return $this->routeMatch->getParameter($parameter);
  }

}
