<?php

declare(strict_types=1);

namespace Drupal\advanced_message_subscription\Message;

use Drupal\advanced_message_subscription\AdvancedMessageSubscriptionInterface;
use Drupal\message\MessageInterface;

/**
 * Interface for classes that may populate d.
 */
interface MessageCreationInterface {

  /**
   * Initialize a new message.
   *
   * @param \Drupal\message\MessageInterface $message
   *   The new message, ready for manipulation.
   * @param \Drupal\advanced_message_subscription\AdvancedMessageSubscriptionInterface $subscription
   *   The subscription that is creating the message.
   * @param array $data
   *   Additional data available during message creation.
   */
  public function initializeNewMessage(MessageInterface $message, AdvancedMessageSubscriptionInterface $subscription, array $data = []): void;

}
