<?php

namespace Drupal\advanced_message_subscription\Message;

use Drupal\message\MessageInterface;
use Drupal\Core\Entity\EntityInterface;

/**
 * Handles setting values on messages.
 */
trait MessageEntityTrait {

  /**
   * Set an entity reference field on a message based on configuration.
   *
   * @param array $configuration
   *   Configuration array.
   * @param string $key
   *   The configuration key.
   * @param \Drupal\message\MessageInterface $message
   *   The message.
   * @param \Drupal\Core\Entity\EntityInterface|null $entity
   *   The entity, or NULL if it does not exist (empty field value).
   */
  protected function setMessageEntityRefFromConfig(array $configuration, string $key, MessageInterface $message, ?EntityInterface $entity): void {
    if (!$field_name = $configuration[$key] ?? NULL) {
      return;
    }
    $this->setMessageEntityRef($message, $field_name, $entity);
  }

  /**
   * Set an entity reference field on a message.
   *
   * @param \Drupal\message\MessageInterface $message
   *   The message.
   * @param string $field_name
   *   The field name.
   * @param \Drupal\Core\Entity\EntityInterface|null $entity
   *   The entity, or NULL if it does not exist (empty field value).
   */
  protected function setMessageEntityRef(MessageInterface $message, string $field_name, ?EntityInterface $entity): void {
    if (!$message->hasField($field_name)) {
      return;
    }
    $message->{$field_name} = $entity;
  }

}
