<?php

declare(strict_types=1);

namespace Drupal\advanced_message_subscription\Access;

use Drupal\advanced_message_subscription\DataProvider;
use Drupal\advanced_message_subscription\Entity\AdvancedMessageSubscriptionType;
use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Checks if passed parameter matches the route configuration.
 */
class AdvancedMessageSubscriptionAddAccessChecker implements AccessInterface {

  /**
   * Access callback.
   *
   * @param \Drupal\Core\Routing\RouteMatchInterface $routeMatch
   *   The route match object.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result.
   */
  public function access(RouteMatchInterface $routeMatch): AccessResultInterface {
    $subscription_type = $routeMatch->getParameter('adv_message_subscription_type');
    if (!$subscription_type instanceof AdvancedMessageSubscriptionType) {
      // No subscription type in the route, deny access.
      return AccessResult::forbidden();
    }

    if (!$subscription_type->getPlugin()) {
      // No plugin for the subscription type, deny access.
      return AccessResult::forbidden();
    }

    $dataProvider = new DataProvider($routeMatch);
    return $subscription_type->createAccess($dataProvider);
  }

}
