<?php

namespace Drupal\advanced_toast\Ajax;

use Drupal\Core\Ajax\CommandInterface;

/**
 * AJAX command for adding a toast notification.
 */
class AddToastCommand implements CommandInterface {

  /**
   * The rendered toast component.
   *
   * @var string
   */
  protected $html;

  /**
   * Toast metadata.
   *
   * @var array
   */
  protected $toastData;

  /**
   * Constructs an AddToastCommand object.
   *
   * @param string $html
   *   The rendered toast HTML.
   * @param array $toast_data
   *   Toast metadata (type, duration, etc.).
   */
  public function __construct($html, array $toast_data = []) {
    $this->html = $html;
    $this->toastData = $toast_data;
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    return [
      'command' => 'addToast',
      'html' => $this->html,
      'toastData' => $this->toastData,
    ];
  }

}
