<?php

namespace Drupal\advanced_toast\Element;

use Drupal\Core\Render\Attribute\RenderElement;
use Drupal\Core\Render\Element\RenderElementBase;

/**
 * Provides a toast messages element.
 *
 * Used to display toast notifications via lazy builder.
 *
 * Usage example:
 * @code
 * $build['toast_messages'] = [
 *   '#type' => 'advanced_toast_messages',
 * ];
 * @endcode
 */
#[RenderElement('advanced_toast_messages')]
class AdvancedToastMessages extends RenderElementBase {

  /**
   * {@inheritdoc}
   */
  public function getInfo() {
    return [
      '#pre_render' => [
        static::class . '::generatePlaceholder',
      ],
    ];
  }

  /**
   * #pre_render callback to generate a placeholder.
   *
   * @param array $element
   *   A renderable array.
   *
   * @return array
   *   The updated renderable array containing the placeholder.
   */
  public static function generatePlaceholder(array $element) {
    $build = [
      '#lazy_builder' => [
        'advanced_toast.lazy_builder:renderToasts',
        [],
      ],
      '#create_placeholder' => TRUE,
    ];

    // Directly create a placeholder as we need this to be placeholdered
    // regardless if this is a POST or GET request.
    $build = \Drupal::service('render_placeholder_generator')->createPlaceholder($build);

    return $build;
  }

}
