# ADVANCED FORM

A UI tweak to /hide/ certain features or the form interface from normal use,
but still have them available on the page for validation and quick access.

This slims down the UI to make things seem simpler, without overloading the
maintenance tasks with layers of permissions, or removing any control from
the user.

## USAGE

When enabled, any configured form can have elements hidden (by css) for
normal use, and a small client-side button [Advanced] can be pressed to reveal
the rest of the form as needed.

## CONFIGURATION

The syntax for defining which form elements are 'hidden' is based entirely
on css selectors, with some shortcuts.

- `.node-form: [#edit-revision-information]` will hide the revision information
fieldset on node forms.

A number of additional css classes are inserted into the form element for
additional, specific control.

Taxonomy terms selected on node forms are also set as context classes, so
it's possible to define rules that only apply when a certain term is
selected in the form.

For example if you have a taxonomy term "Landing page" which is selected via a
select widget the form will get the class `selected-landing-page` applied to it.
This allows you to hide other fields based on that selection.

- `.node-form:[.selected-landing-page #edit-revision-information]` will hide
the revision information fieldset on node forms only when "Landing page" is
selected.

To debug the css or see how it works, look for the element
`<style type="text/css" data-drupal-selector="edit-advancedform-css">`

## BACKGROUND

This is more useful for in-house development with a set of trusted content
editors. It was built for tutoring, where I needed to be able to demonstrate
the functionality of the site as editors would see it, yet still have access
to admin functions without messing around with switch user etc.
So I switched off the clutter.
Collapsed fieldsets are a good start, but there's still too many of them by
the time we start with eCommerce products etc.

Note this 'permission' isn't actually secure - the full form is still
available to browser hacks - like disable css or js

CSS-hide trick for context-sensitive forms developed by dman 2006.
