<?php

namespace Drupal\advancedform\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Settings form for Advancedform.
 */
class AdvancedFormSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'advancedform.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'advancedform_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('advancedform.settings');
    $form['rules_global'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Rules'),
      '#description' => $this->t('Rule selectors to hide inputs, e.g. <code>.node-form: [#edit-revision-information]</code> will hide the revision information fieldset on node forms, or <code>.node-form:[.selected-landing-page #edit-revision-information]</code> will hide the revision information fieldset on node forms where "Landing page" is the selected option for a select field. One rule per line.'),
      '#default_value' => $config->get('rules_global'),
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $enteredRules = $form_state->getValue('rules_global');
    $rules = trim($enteredRules);
    if (!empty($rules)) {
      $this->config('advancedform.settings')
        ->set('rules_global', $rules)
        ->save();
    }
  }

}
