<?php

namespace Drupal\Tests\advancedform\Functional;

use Drupal\Core\Url;
use Drupal\Tests\BrowserTestBase;

/**
 * Test settings form loads and is restricted by permission.
 *
 * @group advancedform
 */
class SettingsFormTest extends BrowserTestBase {

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'advancedform',
  ];

  /**
   * Default theme for tests.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * A user with permission to administer site configuration.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $user;

  /**
   * Tests that the settings page denies access to anonymous user.
   */
  public function testSettingsFormNoPermissionsDenied() {
    $this->drupalGet(Url::fromRoute('advancedform.settings_form'));
    $this->assertSession()->statusCodeEquals(403);
  }

  /**
   * Tests that the settings page allows a user with the appropriate permission.
   */
  public function testSettingsFormPermissionsAllowed() {
    $this->user = $this->drupalCreateUser(['administer advanced form settings']);
    $this->drupalLogin($this->user);
    $this->drupalGet(Url::fromRoute('advancedform.settings_form'));
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('Advanced Form settings');
  }

}
