Provides an AWS SQS backend for Advanced Queue, allowing Drupal queues to scale via cloud messaging with dead-letter and failure handling.

### Features
The Advanced Queue SQS Plugin replaces the standard database-backed queues with a cloud-native implementation using Amazon SQS.

**Basic functionality:**
- Creates queues in SQS that Drupal can push jobs to and process asynchronously.
- Tracks in-flight and waiting messages to determine queue length.
- Handles failed jobs via a dead-letter queue, with the ability to mark jobs as failed immediately.

**Unique features:**
- AWS-native integration for high scalability and reliability.
- Drupal-admin configuration for queue creation, optional credentials, and custom SQS settings.
- Seamlessly translates Drupal queue operations to SQS semantics, including retries and failure handling.

**Use cases:**
- Offloading heavy or long-running tasks from your web servers.
- Scaling job processing across multiple instances without a shared database.
- Integrating serverless or cloud-based workflows with Drupal.

### Post-Installation
- Install the module like any other Drupal module.
- Navigate to Configuration → Advanced Queue SQS Plugin.
- Create new queues by providing a name, optional AWS credentials, and SQS-specific settings.
- Your queues are now available for Drupal jobs; standard Drupal queue operations will use SQS under the hood.
- Optionally configure dead-letter queues to capture failed jobs.

### Additional Requirements
- Requires Drupal Advanced Queue module.
- Requires AWS PHP SDK (typically included via Composer).
- Access to an AWS account with permissions to manage SQS queues.

### Recommended Modules/Libraries
- Advanced Queue Monitor – for visual monitoring of queues.
- Queue Worker Enhancements – for improved handling of long-running jobs.

### Similar Projects
The default Advanced Queue backend uses SQL-based queues. This module differs by enabling cloud-based scaling with SQS, dead-letter queue handling, and automatic failure translation, which the database backend cannot handle natively.
