Aero Weather
============

The **Aero Weather** module provides functionality for fetching, displaying, and
caching real-time weather data using the [WeatherAPI.com](https://www.weatherapi.com/).
It allows site administrators to add a fully customizable **Aero Weather Block** 
showing live weather conditions and a multi-day forecast for a specified
location.

This module offers **flexible layout options**, a variety of color palettes, and 
optional background images. Administrators can choose to display a forecast
for a configurable number of days, toggle between Celsius and Fahrenheit, and
select which metrics (like wind, precipitation, or humidity) to show. Caching
controls are also available to optimize API requests and improve site
performance.

Ideal for **news sites, travel portals, or any website needing dynamic weather
information**, the Aero Weather module ensures users have accurate and
up-to-date meteorological data.

* * *

### Table of contents

*   [Requirements](#requirements)
*   [Installation](#installation)
*   [API Key Setup](#api-key-setup)
*   [Configuration](#configuration)
*   [Blocks Provided](#blocks-provided)
*   [Hooks](#hooks)
*   [Services](#services)
*   [Caching](#caching)
*   [Customization](#customization)
*   [Troubleshooting](#troubleshooting)
*   [Maintainers](#maintainers)

* * *

### Requirements

This module requires only Drupal core.

* * *

### Installation

Install as you would normally install a contributed Drupal module. For more
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

If using Composer:

    composer require drupal/aero_weather

Enable the module using Drush:

    drush en aero_weather

* * *

### API Key Setup

To fetch weather data, the module requires a valid API key from [WeatherAPI.com](https://www.weatherapi.com/). You can also configure caching to reduce API calls and
improve performance. Follow these steps:

1.  Sign up at [WeatherAPI.com](https://www.weatherapi.com/) and obtain your API key.
2.  Go to: `Configuration → System → Aero Weather Settings`.
3.  Enter your **API Key** in the provided field.
4.  Configure caching options:
    *   **Enable Cache:** Toggle caching on or off.
    *   **Cache Duration:** Enter a numeric value for how long to cache data
    (default: 1).
    *   **Cache Unit:** Choose minutes or hours for the duration.
5.  Save the configuration.

Proper cache configuration ensures up-to-date weather information while
minimizing unnecessary API requests and improving site performance.

* * *

### Configuration

#### Aero Weather Block

The Aero Weather module provides two distinct block types that can be configured
to display weather information.

1.  Go to: `Structure → Block layout → Place block`.
2.  Place an **Aero Weather (Horizontal)** or **Aero Weather (Vertical)** block
in the desired region.
3.  In the block configuration form:
    *   Enter the **Location Name** (e.g., `New York, USA`).
    *   Select the **Layout** (for vertical block) and **Color Palette**.
    *   Choose to display a **Round Border** or upload a **Background Image**.
    *   For the Vertical block, you can also select to **Show Forecast** for a
    specified number of days.
4.  Save the block configuration.

#### Icon Customization

The icons for various weather metrics (humidity, wind, precipitation, etc.) can
be customized via the module's global settings.

1.  Go to: `Configuration → System → Aero Weather Settings`.
2.  Under the **Icon Settings** section, you can configure each icon
individually.
3.  For each metric, you can choose one of three options:
    *   **Upload File:** Upload a custom image (SVG, PNG, JPG, etc.).
    *   **URL:** Provide a URL to an external image file.
    *   **Font:** Enter the HTML markup for a font icon (e.g.,
    `<i class="wi wi-humidity"></i>`).
4.  Save the configuration to apply the changes to all blocks.

* * *

### Blocks Provided

*   **Aero Weather (Horizontal)** – Displays live weather for a single location
in a horizontal layout.
*   **Aero Weather (Vertical)** – Displays live weather with additional details
and an optional daily forecast in a vertical layout.

* * *

### Hooks

The module provides the following hook for extensibility:

*   `hook_aero_weather_data_alter(array &$weather_data)` – Allows other modules
to add, modify, or remove data from the API response before it is rendered.

* * *

### Services

The module defines the following service:

*   `aero_weather.api` – Fetches and caches weather data from
**WeatherAPI.com**.

* * *

### Caching

Weather data is cached to minimize API calls. The caching options include:

*   Enable/disable cache in the global module configuration.
*   Set cache duration (default: 1 hour) and unit (minutes or hours).
*   Cached data expires automatically based on the chosen duration.

* * *

### Customization

You can customize the appearance of the weather blocks by overriding their Twig
templates in your theme.

1.  Identify the template you wish to override:
    *   For the Horizontal block: `aero_weather-horizontal-block.html.twig`
    *   For the Vertical block: `aero_weather-vertical-block.html.twig`
2.  Copy the template file from the module's `templates/` directory to your
theme's `templates/` directory.
3.  Clear the Drupal cache (e.g., `drush cr`) to register the new template.
4.  Edit the template file to apply your custom HTML or CSS classes.

The block layouts use [Swiper.js](https://swiperjs.com/) for the metric and
forecast carousels, which you can configure or replace as needed within your
template override.

* * *

### Troubleshooting

*   Ensure the block is placed in an active region and visible.
*   Check API key validity if weather data does not display.
*   Verify cache settings to ensure data is updated correctly.
*   Inspect template overrides and CSS if the layout does not display
as expected.

* * *

### Maintainers

*   Sujan Shrestha - [sujan-shrestha](https://www.drupal.org/u/sujan-shrestha)
