(function ($, Drupal) {
  Drupal.behaviors.aeroWeatherHorizontalBlock = {
    attach: function (context) {
      once('weather_card_horizontal', '.weather-card-horizontal', context).forEach(function (cardElement) {
        const $card = $(cardElement);
        const $tempUnits = $card.find('.temp-units');
        const $tempSwitches = $card.find('.temp-c-switch, .temp-f-switch');
        const $tempC = $card.find('.temp-c');
        const $tempF = $card.find('.temp-f');

        // Temperature unit switcher
        $tempSwitches.on('click', function () {
          const isC = $(this).hasClass('temp-c-switch');

          $tempC.toggle(isC);
          $tempF.toggle(!isC);

          $tempUnits.find('span').removeClass('font-bold').addClass('opacity-70');
          $tempSwitches.removeClass('font-bold').addClass('opacity-70');
          $(this).addClass('font-bold').removeClass('opacity-70');
        });

        // Helper: Initialize Swiper if container exists
        function initSwiper($container, options) {
          if ($container.length) {
            new Swiper($container[0], options);
          }
        }

        // Shared Swiper options
        const swiperOptions = {
          slidesPerView: 3,
          loop: 1,
          autoplay: {
            delay: 3000,
            disableOnInteraction: 0,
          },
          navigation: 0,
          breakpoints: {
            768: { slidesPerView: 3 },
            480: { slidesPerView: 3 }
          }
        };

        // Init Swipers scoped to this card
        initSwiper($card.find('.swiper-detailed-metrics'), swiperOptions);
        initSwiper($card.find('.swiper-forecast'), swiperOptions);
      });
    }
  };
})(jQuery, Drupal);
