(function ($, Drupal) {
    Drupal.behaviors.aeroWeatherBlock = {
        attach: function (context, settings) {

            // Use once to ensure we only apply this behavior once per weather card
            once('weather_card', '.weather-card-vertical', context).forEach(function (cardElement) {
              const card = $(cardElement);

              // Check if .temp-units input exists before adding event listener
              const tempUnitsInput = card.find('.temp-units input');

              if (tempUnitsInput.length) {  // Only attach the event if the input exists
                tempUnitsInput.on('change', function (e) {
                    const changedElement = $(this); // 'this' refers to the specific input element inside the card
                    tempUnitsInput.attr('checked', 'checked');
                    changedElement.attr('checked', '');

                    // Toggle temperature elements (Celsius/Fahrenheit) visibility based on input change
                    card.find(".temp-c, .temp-f, .min-temp-c, .max-temp-c, .min-temp-f, .max-temp-f").toggle();
                });
              }

              // Check if .forecast-option exists before adding event listener
              const forecastOption = card.find('.forecast-option');
              if (forecastOption.length) {  // Only attach the event if the forecast option exists
                forecastOption.on('change', function (e) {
                    const selectedOption = $(this).val();
                    console.log('Selected forecast option:', selectedOption);

                    // Hide all forecast values initially
                    card.find('.forecast-item .forecast-values span').addClass('hidden');

                    // Show the forecast value corresponding to the selected option
                    card.find(`.forecast - item .value - ${selectedOption}`).removeClass('hidden');
                });

                // Trigger the 'change' event on page load to set the initial state
                forecastOption.trigger('change');
              }

            });
        }
    };
})(jQuery, Drupal);
