<?php

/**
 * @file
 * Hooks provided by the AeroWeather module.
 */

/**
 * Alter the list of color palettes in AeroWeather.
 *
 * Other modules may implement this hook to add, remove, or modify
 * the color palettes used by the AeroWeather module.
 *
 * @param array $palettes
 *   An associative array of color palettes keyed by machine name.
 *   Each palette definition contains:
 *   - label: The human-readable name of the palette (string).
 *
 * @code
 *   Example: Add a new palette
 *   $palettes['palette-31'] = [
 *     'label' => t('Crimson Night'),
 *   ];
 *
 *   Example: Modify an existing palette
 *   if (isset($palettes['palette-2'])) {
 *     $palettes['palette-2']['label'] = t('Golden Sunset');
 *   }
 *
 *   Example: Remove a palette
 *   unset($palettes['palette-5']);
 *
 *   Example usage in a custom module:
 *   function my_module_aero_weather_color_palettes_alter(array &$palettes) {
 *     // Add Crimson Night.
 *     $palettes['palette-31'] = [
 *       'label' => t('Crimson Night'),
 *     ];
 *
 *     // Modify Sunset.
 *     if (isset($palettes['palette-2'])) {
 *       $palettes['palette-2']['label'] = t('Golden Sunset');
 *     }
 *
 *     // Remove Orange Glow.
 *     unset($palettes['palette-5']);
 *   }
 * @endcode
 */
function hook_aero_weather_color_palettes_alter(array &$palettes) {
}
