(function ($, Drupal) {
  Drupal.behaviors.aeroWeatherBlock = {
    attach: function (context, settings) {

      once('weather_card', '.weather-card-vertical', context).forEach(function (cardElement) {
        const card = $(cardElement);

        const tempUnitsInput = card.find('.temp-units input');
        if (tempUnitsInput.length) {
          tempUnitsInput.on('change', function () {
            const changedElement = $(this);
            tempUnitsInput.prop('checked', 'FALSE');
            changedElement.prop('checked', 'TRUE');

            card.find(".temp-c, .temp-f, .min-temp-c, .max-temp-c, .min-temp-f, .max-temp-f").toggle();
          });
        }

        const forecastOption = card.find('.forecast-option');
        if (forecastOption.length) {
          const allowedOptions = ['temperature', 'precipitation', 'wind', 'avghumidity','daily_chance_of_rain','daily_chance_of_snow'];

          forecastOption.on('change', function () {
            const selectedOption = $(this).val();

            // Validate selectedOption before using it in selector
            if (!allowedOptions.includes(selectedOption)) {
              console.warn('Unexpected forecast option:', selectedOption);
              return;
            }

            // Hide all
            card.find('.forecast-item .forecast-values span').addClass('hidden');

            // Show only the matching option
            card.find('.forecast-item .value-' + selectedOption).removeClass('hidden');
          });

          // Trigger once to set initial state
          forecastOption.trigger('change');
        }

      });
    }
  };
})(jQuery, Drupal);
