(function ($, Drupal) {
  Drupal.behaviors.aeroWeatherHorizontalBlock = {
    attach: function (context) {
      once('weather_card_horizontal', '.weather-card-horizontal', context).forEach(function (cardElement) {
        const $card = $(cardElement);
        const $tempUnits = $card.find('.temp-units');
        const $tempSwitches = $card.find('.temp-c-switch, .temp-f-switch');
        const $tempC = $card.find('.temp-c');
        const $tempF = $card.find('.temp-f');

        /**
         * Toggle temperature units and highlight selected unit.
         *
         * @param {boolean} isCelsius - true if Celsius is selected.
         */
        function toggleTemperature(isCelsius) {
          $tempC.toggle(isCelsius);
          $tempF.toggle(!isCelsius);

          $tempUnits.find('span')
            .removeClass('font-bold')
            .addClass('opacity-70');

          $tempSwitches
            .removeClass('font-bold')
            .addClass('opacity-70');

          const $clicked = isCelsius ? $card.find('.temp-c-switch') : $card.find('.temp-f-switch');
          $clicked
            .addClass('font-bold')
            .removeClass('opacity-70');
        }

        // Event listener for temperature switch.
        $tempSwitches.on('click', function () {
          const isCelsius = $(this).hasClass('temp-c-switch');
          toggleTemperature(isCelsius);
        });

        /**
         * Initialize Swiper carousel on given container.
         *
         * @param {jQuery} $container - Swiper container element.
         * @param {Object} options - Swiper config options.
         */
        function initSwiper($container, options) {
          if ($container.length && typeof Swiper !== 'undefined') {
            try {
              new Swiper($container[0], options);
            } catch (e) {
              console.warn('Swiper failed to initialize:', e);
            }
          }
        }

        // Shared Swiper options.
        const swiperOptions = {
          slidesPerView: 3,
          loop: 1,
          autoplay: {
            delay: 3000,
            disableOnInteraction: 0,
          },
          breakpoints: {
            768: { slidesPerView: 3 },
            480: { slidesPerView: 3 }
          }
        };

        // Initialize Swiper sliders within this weather card.
        initSwiper($card.find('.swiper-detailed-metrics'), swiperOptions);
        initSwiper($card.find('.swiper-forecast'), swiperOptions);
      });
    }
  };
})(jQuery, Drupal);
