/**
 * @file
 * JavaScript file for Affiliated tracking.
 */

(function ($, Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.affiliatedTrack = {
    attach: function (context, settings) {
      once('affiliated', 'body').forEach(function (i, el) {
        if (typeof drupalSettings.affiliated != 'undefined') {
          const urlParams = new URLSearchParams(window.location.search);
          const affiliateCode = urlParams.get(drupalSettings.affiliated.affiliate_key);
          if (affiliateCode) {
            console.log(document.location);
            const trackData = {
              referrerUrl: document.location.href !== document.referrer ? document.referrer : '',
              landingPage: document.location.pathname,
              affiliate: affiliateCode,
              campaign: urlParams.get(drupalSettings.affiliated.campaign_key),
            };
            console.log(trackData, 'affiliated track visit');
            $.ajax({
              url: Drupal.url(`affiliated/track`),
              type: 'POST',
              data: trackData,
              dataType: 'json',
              success: function (data) {
                console.log(data, 'tracking response');
              },
              error: function () {
                //alert('error');
              },
            });
          }

        }
      });
    },
  };
})(jQuery, Drupal, drupalSettings);
