<?php

namespace Drupal\affiliated\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\Core\Entity\EntityPublishedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Interface for Affiliate Campaign entities.
 */
interface AffiliateCampaignInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface, EntityPublishedInterface {

  /**
   * Gets the affiliate user who owns this campaign.
   *
   * @return \Drupal\user\UserInterface|null
   *   The affiliate user entity, or NULL if not set.
   */
  public function getAffiliate();

  /**
   * Checks if this is the default campaign for the affiliate.
   *
   * @return bool
   *   TRUE if this is the default campaign, FALSE otherwise.
   */
  public function isDefault();

  /**
   * Sets whether this is the default campaign for the affiliate.
   *
   * @param bool $value
   *   TRUE to set as default, FALSE otherwise.
   *
   * @return $this
   */
  public function setDefault($value = TRUE);

}
