<?php

namespace Drupal\affiliated\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityPublishedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Interface for Affiliate Conversion entities.
 */
interface AffiliateConversionInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface, EntityPublishedInterface {

  /**
   * Gets the bundle entity for this conversion.
   *
   * @return \Drupal\affiliated\Entity\AffiliateConversionTypeInterface
   *   The conversion type bundle entity.
   */
  public function getBundle();

  /**
   * Gets the affiliate user entity.
   *
   * @return \Drupal\user\UserInterface|\Drupal\Core\Session\AnonymousUserSession
   *   The affiliate user entity, or anonymous session if no affiliate is set.
   */
  public function getAffiliate();

  /**
   * Gets the affiliate user ID.
   *
   * @return int|null
   *   The affiliate user ID, or NULL if not set.
   */
  public function getAffiliateId();

  /**
   * Gets the campaign entity.
   *
   * @return \Drupal\affiliated\Entity\AffiliateCampaignInterface|null
   *   The campaign entity, or NULL if not set.
   */
  public function getCampaign();

  /**
   * Gets the campaign entity ID.
   *
   * @return int|null
   *   The campaign entity ID, or NULL if not set.
   */
  public function getCampaignId();

  /**
   * Gets the parent entity associated with this conversion.
   *
   * @return \Drupal\Core\Entity\EntityInterface|null
   *   The parent entity, or NULL if not set or cannot be loaded.
   */
  public function getParentEntity();

  /**
   * Gets the parent entity type ID.
   *
   * @return string|null
   *   The parent entity type ID, or NULL if not set.
   */
  public function getParentEntityTypeId();

  /**
   * Gets the parent entity ID.
   *
   * @return string|null
   *   The parent entity ID, or NULL if not set.
   */
  public function getParentEntityId();

  /**
   * Sets the parent entity for this conversion.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The parent entity to associate with this conversion.
   */
  public function setParentEntity(EntityInterface $entity);

  /**
   * Sets the commission for a conversion.
   *
   * @param float $value
   *   The numeric value for the commission.
   * @param string $currency
   *   The currency of the value.
   */
  public function setCommission(float $value, string $currency = '');

  /**
   * Gets the commission amount and currency.
   *
   * @return array
   *   An associative array with:
   *   - amount: The commission amount (float).
   *   - currency: The currency code (string).
   */
  public function getCommission();

  /**
   * Checks if the conversion is approved.
   *
   * @return bool
   *   TRUE if the conversion is published/approved, FALSE otherwise.
   */
  public function isApproved();

}
