<?php

namespace Drupal\affiliated\Event;

// For Drupal 10+ (recommended)
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event that is fired when an affiliate account is looked up.
 */
class AffiliatedAccountLookupEvent extends Event {

  // This makes it easier for subscribers to reliably use our event name.
  const EVENT_NAME = 'affiliated_account_lookup';

  /**
   * The user account.
   *
   * @var \Drupal\user\UserInterface
   */
  private $account;

  /**
   * The unique affiliate code to lookup.
   *
   * @var string
   */
  private $code;

  /**
   * Constructs the object.
   *
   * @param \Drupal\user\UserInterface $account
   *   The account of the user logged in.
   */
  public function __construct($code, $account) {
    $this->account = $account;
    $this->code = $code;
  }

  /**
   *
   */
  public function setAccount($account) {
    $this->account = $account;
    return $this->account;
  }

  /**
   *
   */
  public function getAccount() {
    return $this->account;
  }

  /**
   *
   */
  public function getCode() {
    return $this->code;
  }

}
