<?php

/**
 * @file
 * Token hooks for the Affiliated module.
 */

use Drupal\Core\Render\BubbleableMetadata;

/**
 * Implements hook_token_info_alter().
 */
function affiliated_token_info_alter(&$data) {
  $data['tokens']['affiliate_conversion']['parent'] = [
    'name' => t("Parent entity"),
    'description' => t('The parent entity for the conversion'),
  ];
}

/**
 * Implements hook_tokens().
 */
function affiliated_tokens($type, $tokens, array $data, array $options, BubbleableMetadata $bubbleable_metadata): array {
  $token_service = \Drupal::token();
  $replacements = [];
  if ($type == 'affiliate_conversion' && !empty($data['affiliate_conversion'])) {
    /** @var \Drupal\affiliated\Entity\AffiliateConversion $affiliate_conversion */
    $conversion = $data['affiliate_conversion'];
    foreach ($tokens as $name => $original) {
      switch ($name) {
        case 'parent':
          $entity = $conversion->getParentEntity();
          if ($entity) {
            $bubbleable_metadata->addCacheableDependency($entity);
            $title = $entity->label();
            $replacements[$original] = $title;
          }
          break;
      }
    }
    // Chained token relationships.
    if ($entity_tokens = $token_service->findWithPrefix($tokens, 'parent')) {
      /** @var \Drupal\Core\Entity\EntityInterface $entity */
      $entity = $conversion->getParentEntity();
      if ($entity) {
        $replacements += $token_service->generate($entity->getEntityTypeId(), $entity_tokens, [$entity->getEntityTypeId() => $entity], $options, $bubbleable_metadata);
      }
    }
  }

  return $replacements;
}
