<?php

namespace Drupal\affiliated\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates the NotNumeric constraint.
 */
class NotNumericConstraintValidator extends ConstraintValidator {

  /**
   * {@inheritdoc}
   */
  public function validate(mixed $value, Constraint $constraint): void {
    if (!isset($value) || $value === '') {
      return;
    }

    // Check if the value is purely numeric (would conflict with entity IDs).
    if (is_numeric($value)) {
      $this->context->addViolation($constraint->message);
    }
  }

}
