<?php

namespace Drupal\affiliated\Plugin\views\field;

use Drupal\Component\Render\MarkupInterface;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Field handler to render the title of an affiliate_conversions parent entity.
 *
 * @ViewsField("affiliate_conversion_parent_entity")
 */
class AffiliateConversionParentEntity extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values): string|MarkupInterface {
    $entity = $this->getEntity($values);
    if ($parent = $entity->getParentEntity()) {
      return $parent->label() ?? '';
    }
    return '';
  }

}
