<?php

namespace Drupal\affiliated\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Alters routes for affiliated entities.
 */
class AffiliatedRouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    // Restrict canonical pages for clicks and conversions to users who
    // can edit the entity. These entities can still be viewed in Views,
    // but the full page requires edit access.
    $restricted_routes = [
      'entity.affiliate_click.canonical',
      'entity.affiliate_conversion.canonical',
    ];

    foreach ($restricted_routes as $route_name) {
      if ($route = $collection->get($route_name)) {
        $route->setRequirement('_affiliated_entity_edit_access', 'TRUE');
      }
    }
  }

}
