<?php

namespace Drupal\Tests\affiliated\Kernel\Entity;

use Drupal\Tests\affiliated\Kernel\AffiliatedKernelTestBase;

/**
 * Tests the AffiliateClick entity.
 *
 * @group affiliated
 * @coversDefaultClass \Drupal\affiliated\Entity\AffiliateClick
 */
class AffiliateClickTest extends AffiliatedKernelTestBase {

  /**
   * Tests creating an affiliate click entity.
   */
  public function testCreateClick(): void {
    $user = $this->createAffiliateUser();
    $campaign = $this->entityTypeManager->getStorage('affiliate_campaign')->create([
      'user_id' => 0,
      'name' => 'Test Campaign',
      'is_default' => 1,
    ]);
    $campaign->save();

    $click = $this->entityTypeManager->getStorage('affiliate_click')->create([
      'affiliate' => $user->id(),
      'campaign' => $campaign->id(),
      'hostname' => '192.168.1.1',
      'referrer' => 'https://example.com',
      'destination' => '/products/test',
    ]);
    $click->save();

    $this->assertNotEmpty($click->id());
    $this->assertEquals($user->id(), $click->get('affiliate')->target_id);
    $this->assertEquals($campaign->id(), $click->get('campaign')->target_id);
    $this->assertEquals('192.168.1.1', $click->get('hostname')->value);
    $this->assertEquals('https://example.com', $click->get('referrer')->value);
    $this->assertEquals('/products/test', $click->get('destination')->value);
  }

  /**
   * Tests the click label.
   */
  public function testClickLabel(): void {
    $click = $this->entityTypeManager->getStorage('affiliate_click')->create([
      'hostname' => '127.0.0.1',
    ]);
    $click->save();

    $label = $click->label();
    $this->assertStringContainsString((string) $click->id(), (string) $label);
  }

  /**
   * Tests that created timestamp is set automatically.
   */
  public function testCreatedTimestamp(): void {
    $click = $this->entityTypeManager->getStorage('affiliate_click')->create([
      'hostname' => '127.0.0.1',
    ]);
    $click->save();

    $this->assertNotEmpty($click->get('created')->value);
    $this->assertLessThanOrEqual(time(), $click->get('created')->value);
  }

}
