<?php

namespace Drupal\affiliated\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\Core\Entity\EntityDescriptionInterface;

/**
 * Provides an interface for defining Affiliate Conversion type entities.
 */
interface AffiliateConversionTypeInterface extends ConfigEntityInterface, EntityDescriptionInterface {

  /**
   * Gets the conversion type description.
   *
   * @return string
   *   The description.
   */
  public function getDescription();

  /**
   * Sets the conversion type description.
   *
   * @param string $description
   *   The description.
   *
   * @return \Drupal\affiliated\Entity\AffiliateConversionTypeInterface
   *   The Conversion Type/Bundle
   */
  public function setDescription($description);

  /**
   * Gets the label pattern for conversions of this type.
   *
   * @return string
   *   The label pattern with token placeholders.
   */
  public function getLabelPattern();

  /**
   * Gets whether new conversions should be published by default.
   *
   * @return bool
   *   TRUE if new conversions are published by default, FALSE otherwise.
   */
  public function getDefaultStatus(): bool;

}
