<?php

namespace Drupal\affiliated\Entity\Handler;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of Affiliate Conversion type entities.
 */
class AffiliateConversionTypeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Conversion type');
    $header['id'] = $this->t('Machine name');
    $header['description'] = $this->t('Description');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['label'] = $entity->label();
    $row['id'] = $entity->id();
    $row['description'] = $entity->getDescription();
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build = parent::render();

    if ($build['table']) {
      $build['table']['#empty'] = [
        '#theme' => 'status_messages',
        '#message_list' => [
          'warning' => [
            $this->t("<strong>No conversion types have been configured.</strong>"),
            $this->t("Without conversion types, this module only functions only as an affiliate visitor tracking system (clicks)."),
            $this->t("To track conversions, either create a custom conversion type and trigger it in a custom module or install one of the included submodules: <ul>
<li><strong>Affiliate Commerce</strong> (for commerce sales)</li>
<li><strong>Affiliate Registrations</strong> (for user signups)</li>
<li><strong>Affiliate Webform</strong> (for webform submissions)</li></ul>"),
          ],
        ],
      ];
    }

    return $build;
  }

}
