<?php

namespace Drupal\affiliated\Exception;

/**
 * Exception thrown when a conversion is rejected during creation.
 *
 * This exception is thrown from AffiliateConversion::preSave() when
 * a subscriber to the ConversionPreCreateEvent rejects the conversion.
 *
 * The custom storage handler (AffiliateConversionStorage) catches this
 * exception and handles it silently, returning FALSE from save() instead
 * of throwing. The rejection reason is stored on the entity and can be
 * retrieved via $conversion->getRejectionReason().
 *
 * @see \Drupal\affiliated\Event\ConversionPreCreateEvent
 * @see \Drupal\affiliated\Storage\AffiliateConversionStorage
 */
class ConversionRejectedException extends \RuntimeException {

}
