<?php

namespace Drupal\Tests\affiliated\Kernel;

use Drupal\affiliated\Entity\AffiliateCampaignInterface;
use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\user\Traits\UserCreationTrait;
use Drupal\user\UserInterface;

/**
 * Base class for Affiliated kernel tests.
 */
abstract class AffiliatedKernelTestBase extends KernelTestBase {

  use UserCreationTrait;

  /**
   * {@inheritdoc}
   *
   * Disable strict config schema checking because views configs may have
   * site-specific display extenders.
   */
  protected $strictConfigSchema = FALSE;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'user',
    'views',
    'affiliated',
  ];

  /**
   * The affiliate manager service.
   *
   * @var \Drupal\affiliated\AffiliateManager
   */
  protected $affiliateManager;

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('user');
    $this->installEntitySchema('affiliate_click');
    $this->installEntitySchema('affiliate_campaign');
    $this->installEntitySchema('affiliate_conversion');
    $this->installConfig(['affiliated']);

    $this->affiliateManager = $this->container->get('affiliate.manager');
    $this->entityTypeManager = $this->container->get('entity_type.manager');
  }

  /**
   * Creates a user with the affiliate permission.
   *
   * @return \Drupal\user\UserInterface
   *   The created user.
   */
  protected function createAffiliateUser(): UserInterface {
    return $this->createUser(['act as an affiliate']);
  }

  /**
   * Gets the default campaign.
   *
   * @return \Drupal\affiliated\Entity\AffiliateCampaignInterface|null
   *   The default campaign or NULL.
   */
  protected function getDefaultCampaign(): ?AffiliateCampaignInterface {
    return $this->affiliateManager->getDefaultCampaign();
  }

}
