# A-Frame Module Installation Guide

## Quick Start

### 1. Enable the Module
```bash
drush en aframe -y
drush cr
```

### 2. Configure the Module
Visit `/admin/config/media/aframe` to configure:
- Library source (CDN recommended)
- A-Frame version
- Default scene settings
- Inspector access permissions

### 3. Set Up a 3D Model Field

**Create a file field:**
```bash
# Using Drush (optional)
drush field:create node article field_model
# Follow prompts to create a File field
```

**Or via UI:**
1. Go to Structure → Content types → [Your type] → Manage fields
2. Add a new field → File
3. Name it (e.g., "3D Model")
4. Configure file extensions: `glb gltf obj dae`

**Configure the display:**
1. Go to Manage display
2. Change format to "A-Frame 3D Model Viewer"
3. Click the gear icon to configure:
   - Scene size
   - Camera position
   - Controls type
   - Lighting

### 4. Set Up a Scene Builder Field

**Create a text field:**
1. Go to Structure → Content types → [Your type] → Manage fields
2. Add a new field → Text (formatted, long)
3. Name it (e.g., "VR Scene")

**Configure the widget:**
1. Go to Manage form display
2. Change widget to "A-Frame Inspector Scene Builder"
3. Click the gear icon to configure:
   - Include base scene
   - Default camera position
   - Enable stats

**Grant inspector access:**
1. Go to `/admin/config/media/aframe`
2. Under "Inspector Settings", check roles that should access the visual editor
3. Save configuration

## Testing

### Test the Model Formatter
1. Create/edit content with your 3D model field
2. Upload a test model (you can download free models from [Sketchfab](https://sketchfab.com/features/gltf))
3. Save and view your content
4. You should see an interactive 3D scene

### Test the Inspector Widget
1. Create/edit content with your VR scene field
2. Click "Open A-Frame Inspector"
3. A modal should open with a 3D scene
4. Press `Ctrl+Alt+I` to toggle the inspector panel
5. Add/modify entities
6. Click "Save Scene" to save changes

## Troubleshooting

### Module won't enable
```bash
# Check for errors
drush en aframe -y -vvv

# Clear cache
drush cr
```

### A-Frame not loading
1. Check browser console for errors
2. Verify CDN is accessible (check network tab)
3. Try switching to/from local library source

### Permission issues
```bash
# Grant permission to administrators
drush role:perm:add administrator 'administer site configuration'
```

### Clear cache after configuration changes
```bash
drush cr
```

## Next Steps

- Read the [README.md](README.md) for detailed feature documentation
- Configure default scene settings for your site
- Create content with 3D models or VR scenes
- Customize templates in your theme if needed

## Getting Help

- Check browser console for JavaScript errors
- Enable Drupal development mode for better error messages
- Check file permissions for uploaded 3D models
