# A-Frame Integration Module

Integrates the A-Frame WebVR framework with Drupal 10/11, providing field formatters and widgets for immersive 3D/VR content.

## Features

### 1. Configuration Form
Located at `/admin/config/media/aframe`, the configuration form allows you to:
- Choose between CDN or local A-Frame library
- Set the A-Frame version to use
- Configure default scene settings (background color, fog)
- Set default lighting (ambient and directional)
- Control which roles can access the A-Frame Inspector

### 2. Field Formatter: A-Frame 3D Model Viewer
A field formatter for **File fields** that displays 3D models in an interactive A-Frame scene.

**Supported file formats:**
- glTF (.gltf, .glb) - recommended
- OBJ (.obj)
- Collada (.dae)

**Configurable settings:**
- Scene dimensions (width/height)
- Camera position and rotation
- Camera controls (orbit, look, or none)
- Model position, scale, and rotation
- Auto-rotation
- Background color
- Custom lighting or use global defaults

**Usage:**
1. Create or edit a File field on any content type
2. Go to "Manage display"
3. Select "A-Frame 3D Model Viewer" as the formatter
4. Configure the display settings

### 3. Field Widget: A-Frame Inspector Scene Builder
A field widget for **Text (long)** fields that allows visual scene building using the A-Frame Inspector.

**Features:**
- Visual scene editor with drag-and-drop
- Stores complete A-Frame scene HTML
- Access control based on user roles
- Default starter scene with basic entities
- Save/Cancel functionality

**Usage:**
1. Create or edit a Text (long) field on any content type
2. Go to "Manage form display"
3. Select "A-Frame Inspector Scene Builder" as the widget
4. Configure widget settings:
   - Include base scene structure
   - Default camera position
   - Enable performance stats

**Using the Inspector:**
1. Click "Open A-Frame Inspector" button
2. Use the visual editor to build your scene
3. Press `Ctrl+Alt+I` (or `Cmd+Option+I` on Mac) to toggle inspector
4. Click "Save Scene" to store the HTML

## Installation

1. Copy the module to `/modules/custom/aframe`
2. Enable the module: `drush en aframe -y`
3. Configure settings at `/admin/config/media/aframe`
4. Grant "administer site configuration" permission or configure inspector roles

## Configuration

### Library Source
- **CDN (recommended):** Loads A-Frame from jsDelivr CDN
- **Local:** Requires downloading A-Frame to `/modules/custom/aframe/libraries/`

### Default Scene Settings
Set global defaults for:
- Background color
- Fog (type, color, distance)
- Ambient lighting
- Directional lighting

### Inspector Access
Select which user roles can use the visual A-Frame Inspector. Users without access can still edit scene HTML manually.

## Examples

### Example 1: Display a 3D Model
1. Add a File field to your content type
2. Configure display formatter as "A-Frame 3D Model Viewer"
3. Upload a `.glb` or `.gltf` file
4. View your content to see the interactive 3D model

### Example 2: Build a VR Scene
1. Add a Text (long) field to your content type
2. Configure form widget as "A-Frame Inspector Scene Builder"
3. Create content and click "Open A-Frame Inspector"
4. Add entities, adjust lighting, position objects
5. Save the scene

### Example 3: Display Saved Scenes
To display scenes created with the Inspector widget:
1. Create a custom formatter or use "Default" formatter
2. The HTML will be rendered directly
3. Ensure A-Frame library is loaded on the page

## Technical Details

### JavaScript Libraries
- **aframe-loader.js:** Dynamically loads A-Frame based on configuration
- **aframe-inspector-loader.js:** Loads the A-Frame Inspector
- **inspector-widget.js:** Handles inspector modal and scene saving
- **model-viewer.js:** Adds auto-rotate component for models

### Drupal Settings
The module exposes configuration to JavaScript via `drupalSettings.aframe`:
```javascript
{
  library_source: 'cdn',
  aframe_version: '1.5.0'
}
```

### Custom A-Frame Components
- **auto-rotate:** Automatically rotates entities on the Y-axis

## Troubleshooting

### Models not displaying
- Check that the file format is supported
- Verify the file is accessible (check file permissions)
- Check browser console for errors
- Try a different model file

### Inspector not opening
- Verify user has permission (check inspector roles in config)
- Check that A-Frame and Inspector are loading (browser console)
- Ensure JavaScript is enabled

### Using Local Libraries
To use local copies instead of CDN:
1. Download A-Frame from https://github.com/aframevr/aframe/releases
2. Download A-Frame Inspector from https://github.com/aframevr/aframe-inspector/releases
3. Create directory structure:
   ```
   modules/custom/aframe/libraries/
   ├── aframe/
   │   └── aframe-master.min.js
   └── aframe-inspector/
       └── aframe-inspector.min.js
   ```
4. Select "Local" in the configuration form

## Credits

- **A-Frame:** https://aframe.io/
- **A-Frame Inspector:** https://github.com/aframevr/aframe-inspector

## License

GPL-2.0+
