/**
 * @file
 * Handles auto-rotation for A-Frame model viewer.
 */

(function () {
  'use strict';

  // Register auto-rotate component as soon as A-Frame is available
  function initAutoRotate() {
    if (typeof AFRAME === 'undefined') {
      setTimeout(initAutoRotate, 50);
      return;
    }

    // Register animation component if not already registered
    if (!AFRAME.components['auto-rotate']) {
      AFRAME.registerComponent('auto-rotate', {
        schema: {
          speed: {type: 'number', default: 1}
        },
        tick: function (time, timeDelta) {
          this.el.object3D.rotation.y += (this.data.speed * timeDelta) / 1000;
        }
      });
    }
  }

  // Start initialization immediately
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', initAutoRotate);
  } else {
    initAutoRotate();
  }

})();
