<?php

namespace Drupal\afterburner\Task;

use Drupal\Core\DrupalKernel;
use Spatie\Async\Task;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

abstract class TaskBase extends Task {

  /**
   * @var \Symfony\Component\HttpFoundation\Request
   */
  private Request $request;

  /**
   * @var \Drupal\Core\DrupalKernel
   */
  private DrupalKernel $kernel;

  private array $context;

  public function __construct() {
    $this->context = [
      'host' => \Drupal::request()->getHost(),
      'site_path' => \Drupal::getContainer()->getParameter('site.path'),
      'app_root' => DRUPAL_ROOT,
    ];
  }

  /**
   * Handle Drupal's boot process before executing the task.
   *
   * @return void
   * @throws \Exception
   */
  public function configure(): void {
    $_SERVER['HTTP_HOST'] = $this->context['host'];

    $this->request = Request::createFromGlobals();
    $autoloader = require $this->context['app_root'] . '/autoload.php';

    $this->kernel = DrupalKernel::createFromRequest($this->request, $autoloader, 'prod', TRUE, $this->context['app_root']);
    $this->kernel->setSitePath($this->context['site_path']);

    $this->kernel
      ->boot()
      ->preHandle($this->request);
  }

  public function __invoke()
  {
    parent::__invoke();
    $this->kernel->terminate($this->request, new Response());
  }

}
